package topdown.concrete_operator;

import topdown.data_structures.*;
import java.util.List;

public class ConcreteUnion implements ConcreteOperator {

    private List<ConcreteOperator> operators;
    private int currentOperatorIndex;

    public ConcreteUnion(
            List<ConcreteOperator> operators
    ) {
        this.operators = operators;

        // operator, which currently returns tuples
        this.currentOperatorIndex = 0;
    }

    /**
     * For current operator O_i, get its next tuple and check for any duplicate tuple
     * in union of operators O_1, ..., O_(i-1).
     * If O_i has no next tuple, move to the next operator if there is any.
     * */
    @Override
    public Tuple next() {
        while (currentOperatorIndex < operators.size()) {
            Tuple currentTuple = operators.get(currentOperatorIndex).next();
            if (currentTuple == null) {
                currentOperatorIndex++;
                continue;
            }

            while (currentTuple != null) {
                boolean duplicate = false;

                for (int i = 0; i < currentOperatorIndex; i++) {
                    operators.get(i).reset();
                    Tuple prevTuple = operators.get(i).next();

                    while (prevTuple != null) {
                        if (currentTuple.equals(prevTuple)) {
                            duplicate = true;
                            break;
                        }
                        prevTuple = operators.get(i).next();
                    }
                }
                if (!duplicate) return currentTuple;
                currentTuple = operators.get(currentOperatorIndex).next();
            }
            currentOperatorIndex++;
        }
        return null;
    }

    @Override
    public void reset() {
        for (ConcreteOperator op : operators) {
            op.reset();
        }
    }

    @Override
    public ConcreteOperator instance() {
        ConcreteUnion result = new ConcreteUnion(
                operators
        );
        result.reset();

        return result;
    }

}
